function [TM_curve,TM_comp]=TM_fitting(Tst_t)

% The steering testing stage is subject to significant error percentages at
% low testing times of less than 50 ms. This MATLAB function has been
% included to compensate for this time error using a MATLAB curve fitting
% tool where the steering algorithm has to calculate the compensated testing 
% value before applying it to the PZTs. 

% First Order Fitting 
% Linear model Poly1:
%      f(x) = p1*x + p2
% Coefficients (with 95% confidence bounds):
%        p1 =      0.9886  (0.9736, 1.004)
%        p2 =       16.33  (9.413, 23.26)
% 
% Goodness of fit:
%   SSE: 45.65
%   R-square: 0.9999
%   Adjusted R-square: 0.9999
%   RMSE: 3.901

Tst_t=Tst_t*1000;% convert testing time to ms.
p1=0.9886;p2=16.33; % polynominal coefficients
if Tst_t <= p2
    uiwait(msgbox('Not Recommended Testing Time'));
    Tst_t=17.35; % if testing time less 16.33 ms reassign to 17.35 ms
end
TM_curve=p1*Tst_t + p2;
TM_rec=(Tst_t-p2)/p1;% Recommended Testing Time to get the required Tst_t.
TM_comp=TM_rec/1000;% convert testing time to seconds.
end